/*
 * Decompiled with CFR 0.152.
 */
package me.mmmjjkx.betterChests.items.chests.ie;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.DistinctiveItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.Pair;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mmmjjkx.betterChests.BCGroups;
import me.mmmjjkx.betterChests.BetterChests;
import me.mmmjjkx.betterChests.items.chests.ie.IEStorageCache;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.InventoryBlock;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public final class IEStorageUnit
extends SlimefunItem
implements InventoryBlock,
DistinctiveItem {
    static final NamespacedKey EMPTY_KEY = new NamespacedKey((Plugin)BetterChests.INSTANCE, "empty");
    static final NamespacedKey DISPLAY_KEY = new NamespacedKey((Plugin)BetterChests.INSTANCE, "display");
    private static final NamespacedKey ITEM_KEY = new NamespacedKey((Plugin)BetterChests.INSTANCE, "item");
    private static final NamespacedKey AMOUNT_KEY = new NamespacedKey((Plugin)BetterChests.INSTANCE, "stored");
    static final int INPUT_SLOT = 10;
    static final int DISPLAY_SLOT = 13;
    static final int STATUS_SLOT = 4;
    static final int OUTPUT_SLOT = 16;
    static final int INTERACT_SLOT = 22;
    private static final ItemStack INTERACTION_ITEM = new CustomItemStack(Material.LIME_STAINED_GLASS_PANE, "&aQuick Actions", new String[]{"&bLeft Click: &7Withdraw 1 item", "&bRight Click: &7Withdraw 1 stack", "&bShift Left Click: &7Deposit inventory", "&bShift Right Click: &7Withdraw inventory"});
    private static final ItemStack LOADING_ITEM = new CustomItemStack(Material.CYAN_STAINED_GLASS_PANE, "&bStatus", new String[]{"&7Loading..."});
    final int max;
    private final Map<Location, IEStorageCache> caches = new HashMap<Location, IEStorageCache>();
    public static final PersistentDataType<byte[], ItemStack> ITEM_STACK = new PersistentDataType<byte[], ItemStack>(){

        @NotNull
        public Class<byte[]> getPrimitiveType() {
            return byte[].class;
        }

        @NotNull
        public Class<ItemStack> getComplexType() {
            return ItemStack.class;
        }

        public byte @NotNull [] toPrimitive(@NotNull ItemStack itemStack, @NotNull PersistentDataAdapterContext persistentDataAdapterContext) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            try (BukkitObjectOutputStream output = new BukkitObjectOutputStream((OutputStream)bytes);){
                output.writeObject((Object)itemStack);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return bytes.toByteArray();
        }

        @NotNull
        public ItemStack fromPrimitive(byte @NotNull [] arr, @NotNull PersistentDataAdapterContext persistentDataAdapterContext) {
            ItemStack itemStack;
            ByteArrayInputStream bytes = new ByteArrayInputStream(arr);
            BukkitObjectInputStream input = new BukkitObjectInputStream((InputStream)bytes);
            try {
                itemStack = (ItemStack)input.readObject();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return new CustomItemStack(Material.STONE, "&cERROR", new String[0]);
                }
            }
            input.close();
            return itemStack;
        }
    };

    public IEStorageUnit(SlimefunItemStack item, int max, ItemStack[] recipe) {
        super((ItemGroup)BCGroups.STORAGES, item, RecipeType.ENHANCED_CRAFTING_TABLE, recipe);
        this.max = max;
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public boolean isSynchronized() {
                return true;
            }

            public void tick(Block b, SlimefunItem item, Config data) {
                IEStorageCache cache = IEStorageUnit.this.caches.get(b.getLocation());
                if (cache != null) {
                    cache.tick(b);
                }
            }
        }, new BlockBreakHandler(false, false){

            public void onPlayerBreak(BlockBreakEvent e, ItemStack item, List<ItemStack> drops) {
                BlockMenu menu = BlockStorage.getInventory((Block)e.getBlock());
                IEStorageCache cache = IEStorageUnit.this.caches.remove(menu.getLocation());
                if (cache != null && !cache.isEmpty()) {
                    cache.destroy(e, drops);
                } else {
                    drops.add(IEStorageUnit.this.getItem().clone());
                }
                menu.dropItems(menu.getLocation(), new int[]{10, 16});
            }
        }, new BlockPlaceHandler(false){

            public void onPlayerPlace(BlockPlaceEvent e) {
                IEStorageUnit.this.onPlace(e, e.getBlockPlaced());
            }
        }});
        new BlockMenuPreset(this.getId(), this.getItemName()){

            public void init() {
                IEStorageUnit.this.setup(this);
            }

            public boolean canOpen(@NotNull Block block, @NotNull Player player) {
                return Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, block, Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow itemTransportFlow) {
                return itemTransportFlow == ItemTransportFlow.WITHDRAW ? IEStorageUnit.this.getInputSlots() : IEStorageUnit.this.getOutputSlots();
            }

            public int[] getSlotsAccessedByItemTransport(DirtyChestMenu menu, ItemTransportFlow flow, ItemStack item) {
                return flow == ItemTransportFlow.WITHDRAW ? IEStorageUnit.this.getInputSlots(menu, item) : IEStorageUnit.this.getOutputSlots();
            }

            public void newInstance(@NotNull BlockMenu menu, @NotNull Location l) {
                IEStorageUnit.this.caches.put(l, new IEStorageCache(IEStorageUnit.this, menu));
            }
        };
    }

    static void transferToStack(@Nonnull ItemStack source, @Nonnull ItemStack target) {
        Pair<ItemStack, Integer> data = IEStorageUnit.loadFromStack(source);
        if (data != null) {
            target.setItemMeta(IEStorageUnit.saveToStack(target.getItemMeta(), (ItemStack)data.getFirstValue(), ItemUtils.getItemName((ItemStack)((ItemStack)data.getFirstValue())), (Integer)data.getSecondValue()));
        }
    }

    static ItemMeta saveToStack(ItemMeta meta, ItemStack displayItem, String displayName, int amount) {
        if (meta.hasLore()) {
            List lore = meta.getLore();
            lore.add(ChatColor.GOLD + "Stored: " + displayName + ChatColor.YELLOW + " x " + amount);
            meta.setLore(lore);
        }
        meta.getPersistentDataContainer().set(ITEM_KEY, ITEM_STACK, (Object)displayItem);
        meta.getPersistentDataContainer().set(AMOUNT_KEY, PersistentDataType.INTEGER, (Object)amount);
        return meta;
    }

    public ItemStack getDisplayingItem(Block b) {
        List metadata = b.getMetadata("ie_item");
        if (metadata.isEmpty()) {
            return BlockStorage.getInventory((Block)b).getItemInSlot(13);
        }
        return (ItemStack)((MetadataValue)metadata.get(0)).value();
    }

    public long getCapacity() {
        return this.max;
    }

    @Nullable
    private static Pair<ItemStack, Integer> loadFromStack(ItemStack source) {
        ItemStack item;
        PersistentDataContainer con;
        Integer amount;
        if (source.hasItemMeta() && (amount = (Integer)(con = source.getItemMeta().getPersistentDataContainer()).get(AMOUNT_KEY, PersistentDataType.INTEGER)) != null && (item = (ItemStack)con.get(ITEM_KEY, ITEM_STACK)) != null) {
            return new Pair((Object)item, (Object)amount);
        }
        return null;
    }

    @Nonnull
    public Collection<ItemStack> getDrops() {
        return Collections.emptyList();
    }

    private void onPlace(@Nonnull BlockPlaceEvent e, @Nonnull Block b) {
        Pair<ItemStack, Integer> data = IEStorageUnit.loadFromStack(e.getItemInHand());
        if (data != null) {
            IEStorageCache cache = this.caches.get(b.getLocation());
            cache.load((ItemStack)data.getFirstValue(), ((ItemStack)data.getFirstValue()).getItemMeta());
            cache.amount((Integer)data.getSecondValue());
            b.setMetadata("ie_item", (MetadataValue)new FixedMetadataValue((Plugin)BetterChests.INSTANCE, data.getFirstValue()));
        }
    }

    private void setup(@Nonnull BlockMenuPreset blockMenuPreset) {
        blockMenuPreset.drawBackground(ChestMenuUtils.getInputSlotTexture(), new int[]{0, 1, 2, 9, 11, 18, 19, 20});
        blockMenuPreset.drawBackground(ChestMenuUtils.getBackground(), new int[]{3, 5, 12, 14, 21, 23});
        blockMenuPreset.drawBackground(ChestMenuUtils.getOutputSlotTexture(), new int[]{6, 7, 8, 15, 17, 24, 25, 26});
        blockMenuPreset.addMenuClickHandler(13, ChestMenuUtils.getEmptyClickHandler());
        blockMenuPreset.addItem(22, INTERACTION_ITEM);
        blockMenuPreset.addItem(4, LOADING_ITEM);
    }

    @Nonnull
    private int[] getInputSlots(DirtyChestMenu dirtyChestMenu, ItemStack itemStack) {
        IEStorageCache cache = this.caches.get(((BlockMenu)dirtyChestMenu).getLocation());
        if (cache != null && (cache.isEmpty() || cache.matches(itemStack))) {
            cache.input();
            return new int[]{10};
        }
        return new int[0];
    }

    public int[] getInputSlots() {
        return new int[]{10};
    }

    public int[] getOutputSlots() {
        return new int[]{16};
    }

    public void reloadCache(Block b) {
        this.caches.get(b.getLocation()).reloadData();
    }

    @Nullable
    public IEStorageCache getCache(Location location) {
        return this.caches.get(location);
    }

    public boolean canStack(@Nonnull ItemMeta sfItemMeta, @Nonnull ItemMeta itemMeta) {
        return sfItemMeta.getPersistentDataContainer().equals(itemMeta.getPersistentDataContainer());
    }
}

