/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.advancedban.core.listeners;

import com.balugaq.advancedban.api.enums.EventType;
import com.balugaq.advancedban.api.utils.Debug;
import com.balugaq.advancedban.api.utils.EventUtil;
import com.balugaq.advancedban.api.utils.Predications;
import com.balugaq.advancedban.core.listeners.AListener;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.jetbrains.annotations.NotNull;

public class BlockBreakListener
implements AListener {
    public static final EventType TYPE = EventType.BLOCK_BREAK;

    public static boolean presetPredications(@NotNull BlockBreakEvent event, @NotNull EventPriority eventPriority) {
        String slimefunId = EventUtil.getSlimefunId(event);
        boolean isBypass = EventUtil.isBypass(slimefunId, TYPE, event.getPlayer());
        Debug.debug("isBypass = " + isBypass);
        boolean priority = Predications.getPriority(slimefunId, TYPE) == eventPriority;
        Debug.debug("priority = " + priority);
        Debug.debug("!isBypass && priority = " + (!isBypass && priority));
        return !isBypass && priority;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onLowest(@NotNull BlockBreakEvent event) {
        if (BlockBreakListener.presetPredications(event, EventPriority.LOWEST)) {
            Debug.debug("BlockBreakListener#onLowest(): Cancelled. 9");
            event.setCancelled(true);
            EventUtil.notice((Event)event, TYPE);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onLow(@NotNull BlockBreakEvent event) {
        if (BlockBreakListener.presetPredications(event, EventPriority.LOW)) {
            Debug.debug("BlockBreakListener#onLow(): Cancelled. 10");
            event.setCancelled(true);
            EventUtil.notice((Event)event, TYPE);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onNormal(@NotNull BlockBreakEvent event) {
        if (BlockBreakListener.presetPredications(event, EventPriority.NORMAL)) {
            Debug.debug("BlockBreakListener#onNormal(): Cancelled. 11");
            event.setCancelled(true);
            EventUtil.notice((Event)event, TYPE);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onHigh(@NotNull BlockBreakEvent event) {
        if (BlockBreakListener.presetPredications(event, EventPriority.HIGH)) {
            Debug.debug("BlockBreakListener#onHigh(): Cancelled. 12");
            event.setCancelled(true);
            EventUtil.notice((Event)event, TYPE);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onHighest(@NotNull BlockBreakEvent event) {
        if (BlockBreakListener.presetPredications(event, EventPriority.HIGHEST)) {
            Debug.debug("BlockBreakListener#onHighest(): Cancelled. 13");
            event.setCancelled(true);
            EventUtil.notice((Event)event, TYPE);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onMonitor(@NotNull BlockBreakEvent event) {
        if (BlockBreakListener.presetPredications(event, EventPriority.MONITOR)) {
            Debug.debug("BlockBreakListener#onMonitor(): Cancelled. 14");
            event.setCancelled(true);
            EventUtil.notice((Event)event, TYPE);
        }
    }
}

