/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.advancedban.api.utils;

import com.balugaq.advancedban.api.enums.EventType;
import com.balugaq.advancedban.api.utils.Debug;
import com.balugaq.advancedban.api.utils.Predications;
import com.balugaq.advancedban.implementation.AdvancedBan;
import io.github.thebusybiscuit.slimefun4.api.events.MultiBlockCraftEvent;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.Set;
import lombok.Generated;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventUtil {
    @NotNull
    public static String color(@NotNull String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    @NotNull
    public static String color(@NotNull String message, Object ... args) {
        String coloredMessage = EventUtil.color(message);
        for (int i = 0; i < args.length; i += 2) {
            coloredMessage = coloredMessage.replace("{" + String.valueOf(args[i]) + "}", args[i + 1].toString());
        }
        return coloredMessage;
    }

    @Nullable
    public static String getSlimefunId(@NotNull BlockBreakEvent event) {
        SlimefunItem item = BlockStorage.check((Block)event.getBlock());
        String id = item == null ? null : item.getId();
        Debug.debug("getSlimefunId#BlockBreakEvent: id = " + id);
        return id;
    }

    @Nullable
    public static String getSlimefunId(@NotNull BlockPlaceEvent event) {
        SlimefunItem item = SlimefunItem.getByItem((ItemStack)event.getItemInHand());
        String id = item == null ? null : item.getId();
        Debug.debug("getSlimefunId#BlockPlaceEvent: id = " + id);
        return id;
    }

    @Nullable
    public static String getSlimefunId(@NotNull CraftItemEvent event) {
        SlimefunItem item = SlimefunItem.getByItem((ItemStack)event.getRecipe().getResult());
        String id = item == null ? null : item.getId();
        Debug.debug("getSlimefunId#CraftItemEvent: id = " + id);
        return id;
    }

    @Nullable
    public static String getSlimefunId(@NotNull MultiBlockCraftEvent event) {
        SlimefunItem item = SlimefunItem.getByItem((ItemStack)event.getOutput());
        String id = item == null ? null : item.getId();
        Debug.debug("getSlimefunId#MultiBlockCraftEvent: id = " + id);
        return id;
    }

    @Nullable
    public static String getSlimefunId(@NotNull PlayerDropItemEvent event) {
        SlimefunItem item = SlimefunItem.getByItem((ItemStack)event.getItemDrop().getItemStack());
        String id = item == null ? null : item.getId();
        Debug.debug("getSlimefunId#PlayerDropItemEvent: id = " + id);
        return id;
    }

    @Nullable
    public static String getSlimefunId(@NotNull PlayerInteractEvent event) {
        SlimefunItem item = SlimefunItem.getByItem((ItemStack)event.getItem());
        String id = item == null ? null : item.getId();
        Debug.debug("getSlimefunId#PlayerInteractEvent: id = " + id);
        return id;
    }

    @Nullable
    public static String getSlimefunId(@NotNull ItemStack itemStack) {
        SlimefunItem item = SlimefunItem.getByItem((ItemStack)itemStack);
        String id = item == null ? null : item.getId();
        return id;
    }

    public static void notice(@NotNull Event event, @NotNull EventType eventType) {
        if (event instanceof BlockBreakEvent) {
            BlockBreakEvent bbe = (BlockBreakEvent)event;
            String id = EventUtil.getSlimefunId(bbe);
            if (id == null) {
                return;
            }
            SlimefunItem item = SlimefunItem.getById((String)id);
            if (item == null) {
                return;
            }
            EventUtil.notice((HumanEntity)bbe.getPlayer(), eventType, item.getItemName());
        } else if (event instanceof BlockPlaceEvent) {
            BlockPlaceEvent bpe = (BlockPlaceEvent)event;
            String id = EventUtil.getSlimefunId(bpe);
            if (id == null) {
                return;
            }
            SlimefunItem item = SlimefunItem.getById((String)id);
            if (item == null) {
                return;
            }
            EventUtil.notice((HumanEntity)bpe.getPlayer(), eventType, item.getItemName());
        } else if (event instanceof CraftItemEvent) {
            CraftItemEvent cie = (CraftItemEvent)event;
            String id = EventUtil.getSlimefunId(cie);
            if (id == null) {
                return;
            }
            SlimefunItem item = SlimefunItem.getById((String)id);
            if (item == null) {
                return;
            }
            EventUtil.notice(cie.getWhoClicked(), eventType, item.getItemName());
        } else if (event instanceof MultiBlockCraftEvent) {
            MultiBlockCraftEvent mbce = (MultiBlockCraftEvent)event;
            String id = EventUtil.getSlimefunId(mbce);
            if (id == null) {
                return;
            }
            SlimefunItem item = SlimefunItem.getById((String)id);
            if (item == null) {
                return;
            }
            EventUtil.notice((HumanEntity)mbce.getPlayer(), eventType, item.getItemName());
        } else if (event instanceof PlayerDropItemEvent) {
            PlayerDropItemEvent pde = (PlayerDropItemEvent)event;
            String id = EventUtil.getSlimefunId(pde);
            if (id == null) {
                return;
            }
            SlimefunItem item = SlimefunItem.getById((String)id);
            if (item == null) {
                return;
            }
            EventUtil.notice((HumanEntity)pde.getPlayer(), eventType, item.getItemName());
        } else if (event instanceof PlayerInteractEvent) {
            PlayerInteractEvent pie = (PlayerInteractEvent)event;
            String id = EventUtil.getSlimefunId(pie);
            if (id == null) {
                return;
            }
            SlimefunItem item = SlimefunItem.getById((String)id);
            if (item == null) {
                return;
            }
            EventUtil.notice((HumanEntity)pie.getPlayer(), eventType, item.getItemName());
        }
    }

    public static void notice(@NotNull HumanEntity player, @NotNull EventType eventType, @NotNull String itemName) {
        player.sendMessage(EventUtil.color(eventType.getMessage(), "name", itemName));
    }

    public static boolean isBypass(@Nullable String itemId, @NotNull EventType eventType, @NotNull Player player) {
        if (itemId == null) {
            Debug.debug("Item ID is null, bypassing ban check.");
            return false;
        }
        if (AdvancedBan.getInstance().getConfigManager().isOP_BYPASS_BAN() && player.isOp()) {
            Debug.debug("Player is OP, bypassing ban check.");
            return true;
        }
        if (Predications.isBypassPlayer(itemId, eventType, player.getName()) || Predications.isBypassPlayer(itemId, eventType, player.getDisplayName()) || Predications.isBypassPlayer(itemId, eventType, player.getPlayerListName())) {
            Debug.debug("Player is bypassing ban check because name matched.");
            return true;
        }
        Set<String> permissions = Predications.getBypassPermissions(itemId, eventType);
        if (permissions.isEmpty()) {
            Debug.debug("Player cannot bypass ban check because no permissions are present.");
            return false;
        }
        for (String permission : permissions) {
            if (player.hasPermission(permission)) continue;
            Debug.debug("Player cannot bypass ban check because of missing permission.");
            return false;
        }
        Debug.debug("Player is bypassing ban check because all permissions are present.");
        return true;
    }

    public static boolean isBypass(@Nullable String itemId, @NotNull EventType eventType, HumanEntity humanEntity) {
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            return EventUtil.isBypass(itemId, eventType, player);
        }
        if (itemId == null) {
            return false;
        }
        if (AdvancedBan.getInstance().getConfigManager().isOP_BYPASS_BAN() && humanEntity.isOp()) {
            return true;
        }
        if (Predications.isBypassPlayer(itemId, eventType, humanEntity.getName())) {
            return true;
        }
        for (String permissions : Predications.getBypassPermissions(itemId, eventType)) {
            if (humanEntity.hasPermission(permissions)) continue;
            return false;
        }
        return true;
    }

    @Generated
    private EventUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

