/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.advancedban.api.utils;

import com.balugaq.advancedban.api.enums.EventType;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.bukkit.event.EventPriority;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Predications {
    private static final Map<String, Map<EventType, EventPriority>> PREDICATIONS = new HashMap<String, Map<EventType, EventPriority>>();

    public static void addPredication(@NotNull String itemId, @NotNull EventType type, @NotNull EventPriority priority) {
        if (!PREDICATIONS.containsKey(itemId)) {
            PREDICATIONS.put(itemId, new HashMap());
        }
        PREDICATIONS.get(itemId).put(type, priority);
    }

    @Contract(value="null, _ -> false; _, null -> false;")
    public static boolean preset(@Nullable String itemId, @Nullable EventType type) {
        if (itemId == null || type == null) {
            return false;
        }
        Map<EventType, EventPriority> eventPredications = PREDICATIONS.get(itemId);
        if (eventPredications == null) {
            return false;
        }
        EventPriority eventPriority = eventPredications.get((Object)type);
        return eventPriority != null;
    }

    @Nullable
    @Contract(value="null, _ -> null; _, null -> null;")
    public static EventPriority getPriority(@Nullable String itemId, @Nullable EventType type) {
        if (itemId == null || type == null) {
            return null;
        }
        if (!Predications.preset(itemId, type)) {
            return null;
        }
        return PREDICATIONS.get(itemId).get((Object)type);
    }

    @Nonnull
    public static Map<String, Map<EventType, EventPriority>> getPredications() {
        return PREDICATIONS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPredications() {
        Map<String, Map<EventType, EventPriority>> map = PREDICATIONS;
        synchronized (map) {
            PREDICATIONS.clear();
        }
    }

    @Generated
    private Predications() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

