/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.advancedban.core.managers;

import com.balugaq.advancedban.core.listeners.BlockBreakListener;
import com.balugaq.advancedban.core.listeners.BlockPlaceListener;
import com.balugaq.advancedban.core.listeners.CraftItemListener;
import com.balugaq.advancedban.core.listeners.MultiBlockCraftListener;
import com.balugaq.advancedban.core.listeners.PlayerDropItemListener;
import com.balugaq.advancedban.core.listeners.PlayerInteractListener;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ListenerManager {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final List<Listener> listeners;

    public ListenerManager(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
        this.listeners = new ArrayList<Listener>();
    }

    public void setup() {
        this.listeners.add(new BlockBreakListener());
        this.listeners.add(new BlockPlaceListener());
        this.listeners.add(new CraftItemListener());
        this.listeners.add(new MultiBlockCraftListener());
        this.listeners.add(new PlayerDropItemListener());
        this.listeners.add(new PlayerInteractListener());
    }

    public void load() {
        for (Listener listener : this.listeners) {
            Bukkit.getPluginManager().registerEvents(listener, (Plugin)this.plugin);
        }
    }

    public void unload() {
        for (Listener listener : this.listeners) {
            HandlerList.unregisterAll((Listener)listener);
        }
    }

    @NotNull
    @Generated
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    @Generated
    public List<Listener> getListeners() {
        return this.listeners;
    }
}

