/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.advancedban.core.managers;

import com.balugaq.advancedban.api.annotations.Since;
import com.balugaq.advancedban.api.enums.BuildStation;
import com.balugaq.advancedban.api.enums.ConfigVersion;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ConfigManager {
    @NotNull
    private final FileConfiguration config;
    @Since(value=ConfigVersion.C_20250221_1)
    private final boolean AUTO_UPDATE;
    @Since(value=ConfigVersion.C_20250221_1)
    private final boolean DEBUG;
    @Since(value=ConfigVersion.C_20250221_1)
    @NotNull
    private final String LANGUAGE;
    @NotNull
    private final JavaPlugin plugin;
    @Since(value=ConfigVersion.C_20250221_1)
    private BuildStation BUILD_STATION;
    @Since(value=ConfigVersion.C_20250221_1)
    private ConfigVersion CONFIG_VERSION;

    public ConfigManager(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
        this.config = YamlConfiguration.loadConfiguration((File)new File(plugin.getDataFolder(), "config.yml"));
        this.setupDefaultConfig();
        try {
            this.CONFIG_VERSION = ConfigVersion.valueOf(plugin.getConfig().getString("config-version", "UNKNOWN").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            plugin.getLogger().warning("Invalid config-version value: " + plugin.getConfig().getString("config-version", "UNKNOWN") + ", using default value: UNKNOWN");
            this.CONFIG_VERSION = ConfigVersion.C_UNKNOWN;
        }
        this.AUTO_UPDATE = this.config.getBoolean("auto-update", false);
        this.DEBUG = this.config.getBoolean("debug", false);
        String buildStationStr = this.config.getString("build-station", "Guizhan");
        try {
            this.BUILD_STATION = BuildStation.valueOf(buildStationStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            plugin.getLogger().warning("Invalid build-station value: " + buildStationStr + ", using default value: Guizhan");
            this.BUILD_STATION = BuildStation.GUIZHAN;
        }
        this.LANGUAGE = this.config.getString("language", "zh-CN");
    }

    private void setupDefaultConfig() {
        InputStream inputStream = this.plugin.getResource("config.yml");
        File existingFile = new File(this.plugin.getDataFolder(), "config.yml");
        if (inputStream == null) {
            return;
        }
        InputStreamReader reader = new InputStreamReader(inputStream);
        YamlConfiguration resourceConfig = YamlConfiguration.loadConfiguration((Reader)reader);
        YamlConfiguration existingConfig = YamlConfiguration.loadConfiguration((File)existingFile);
        for (String key : resourceConfig.getKeys(false)) {
            this.checkKey((FileConfiguration)existingConfig, (FileConfiguration)resourceConfig, key);
        }
        try {
            existingConfig.save(existingFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @ParametersAreNonnullByDefault
    private void checkKey(FileConfiguration existingConfig, FileConfiguration resourceConfig, String key) {
        Object currentValue = existingConfig.get(key);
        Object newValue = resourceConfig.get(key);
        if (newValue instanceof ConfigurationSection) {
            ConfigurationSection section = (ConfigurationSection)newValue;
            for (String sectionKey : section.getKeys(false)) {
                this.checkKey(existingConfig, resourceConfig, key + "." + sectionKey);
            }
        } else if (currentValue == null) {
            existingConfig.set(key, newValue);
        }
    }

    public boolean isAutoUpdate() {
        return this.AUTO_UPDATE;
    }

    public boolean isDebug() {
        return this.DEBUG;
    }

    @NotNull
    public String getLanguage() {
        return this.LANGUAGE;
    }

    public BuildStation getBuildStation() {
        return this.BUILD_STATION;
    }

    public ConfigVersion getConfigVersion() {
        return this.CONFIG_VERSION;
    }

    @NotNull
    @Generated
    public FileConfiguration getConfig() {
        return this.config;
    }

    @Generated
    public boolean isAUTO_UPDATE() {
        return this.AUTO_UPDATE;
    }

    @NotNull
    @Generated
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public BuildStation getBUILD_STATION() {
        return this.BUILD_STATION;
    }

    @Generated
    public ConfigVersion getCONFIG_VERSION() {
        return this.CONFIG_VERSION;
    }
}

