/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.advancedban.api.utils;

import com.balugaq.advancedban.api.enums.EventType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.bukkit.event.EventPriority;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Predications {
    private static final Map<String, Map<EventType, EventPriority>> PREDICATIONS = new HashMap<String, Map<EventType, EventPriority>>();
    private static final Map<String, Map<EventType, Set<String>>> BYPASS_PLAYERS = new HashMap<String, Map<EventType, Set<String>>>();
    private static final Map<String, Map<EventType, Set<String>>> BYPASS_PERMISSIONS = new HashMap<String, Map<EventType, Set<String>>>();

    public static void addPredication(@NotNull String itemId, @NotNull EventType type, @NotNull EventPriority priority) {
        if (!PREDICATIONS.containsKey(itemId)) {
            PREDICATIONS.put(itemId, new HashMap());
        }
        PREDICATIONS.get(itemId).put(type, priority);
    }

    public static void addBypassPlayers(@NotNull String itemId, @NotNull EventType type, @NotNull Collection<String> players) {
        if (!BYPASS_PLAYERS.containsKey(itemId)) {
            BYPASS_PLAYERS.put(itemId, new HashMap());
        }
        if (!BYPASS_PLAYERS.get(itemId).containsKey((Object)type)) {
            BYPASS_PLAYERS.get(itemId).put(type, new HashSet());
        }
        BYPASS_PLAYERS.get(itemId).get((Object)type).addAll(players);
    }

    public static void addBypassPlayer(@NotNull String itemId, @NotNull EventType type, @NotNull String player) {
        if (!BYPASS_PLAYERS.containsKey(itemId)) {
            BYPASS_PLAYERS.put(itemId, new HashMap());
        }
        if (!BYPASS_PLAYERS.get(itemId).containsKey((Object)type)) {
            BYPASS_PLAYERS.get(itemId).put(type, new HashSet());
        }
        BYPASS_PLAYERS.get(itemId).get((Object)type).add(player);
    }

    public static void addBypassPermissions(@NotNull String itemId, @NotNull EventType type, @NotNull Collection<String> permissions) {
        if (!BYPASS_PERMISSIONS.containsKey(itemId)) {
            BYPASS_PERMISSIONS.put(itemId, new HashMap());
        }
        if (!BYPASS_PERMISSIONS.get(itemId).containsKey((Object)type)) {
            BYPASS_PERMISSIONS.get(itemId).put(type, new HashSet());
        }
        BYPASS_PERMISSIONS.get(itemId).get((Object)type).addAll(permissions);
    }

    public static void addBypassPermission(@NotNull String itemId, @NotNull EventType type, @NotNull String permission) {
        if (!BYPASS_PERMISSIONS.containsKey(itemId)) {
            BYPASS_PERMISSIONS.put(itemId, new HashMap());
        }
        if (!BYPASS_PERMISSIONS.get(itemId).containsKey((Object)type)) {
            BYPASS_PERMISSIONS.get(itemId).put(type, new HashSet());
        }
        BYPASS_PERMISSIONS.get(itemId).get((Object)type).add(permission);
    }

    public static boolean isBypassPlayer(@NotNull String itemId, @NotNull EventType type, @NotNull String playerName) {
        if (!BYPASS_PLAYERS.containsKey(itemId)) {
            return false;
        }
        if (!BYPASS_PLAYERS.get(itemId).containsKey((Object)type)) {
            return false;
        }
        return BYPASS_PLAYERS.get(itemId).get((Object)type).contains(playerName);
    }

    public static boolean isBypassPermission(@NotNull String itemId, @NotNull EventType type, @NotNull String permission) {
        if (!BYPASS_PERMISSIONS.containsKey(itemId)) {
            return false;
        }
        if (!BYPASS_PERMISSIONS.get(itemId).containsKey((Object)type)) {
            return false;
        }
        return BYPASS_PERMISSIONS.get(itemId).get((Object)type).contains(permission);
    }

    @Contract(value="null, _ -> false; _, null -> false;")
    public static boolean preset(@Nullable String itemId, @Nullable EventType type) {
        if (itemId == null || type == null) {
            return false;
        }
        Map<EventType, EventPriority> eventPredications = PREDICATIONS.get(itemId);
        if (eventPredications == null) {
            return false;
        }
        EventPriority eventPriority = eventPredications.get((Object)type);
        return eventPriority != null;
    }

    @Nullable
    @Contract(value="null, _ -> null; _, null -> null;")
    public static EventPriority getPriority(@Nullable String itemId, @Nullable EventType type) {
        if (itemId == null || type == null) {
            return null;
        }
        if (!Predications.preset(itemId, type)) {
            return null;
        }
        return PREDICATIONS.get(itemId).get((Object)type);
    }

    @Nonnull
    public static Map<String, Map<EventType, EventPriority>> getPredications() {
        return PREDICATIONS;
    }

    @Nonnull
    public static Map<String, Map<EventType, Set<String>>> getBypassPlayers() {
        return BYPASS_PLAYERS;
    }

    @Nonnull
    public static Map<String, Map<EventType, Set<String>>> getBypassPermissions() {
        return BYPASS_PERMISSIONS;
    }

    @Nonnull
    public static Set<String> getBypassPermissions(@NotNull String itemId, @NotNull EventType type) {
        if (!BYPASS_PERMISSIONS.containsKey(itemId)) {
            return new HashSet<String>();
        }
        if (!BYPASS_PERMISSIONS.get(itemId).containsKey((Object)type)) {
            return new HashSet<String>();
        }
        return BYPASS_PERMISSIONS.get(itemId).get((Object)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPredications() {
        Map<String, Map<EventType, EventPriority>> map = PREDICATIONS;
        synchronized (map) {
            PREDICATIONS.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearBypassPlayers() {
        Map<String, Map<EventType, Set<String>>> map = BYPASS_PLAYERS;
        synchronized (map) {
            BYPASS_PLAYERS.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearBypassPermissions() {
        Map<String, Map<EventType, Set<String>>> map = BYPASS_PERMISSIONS;
        synchronized (map) {
            BYPASS_PERMISSIONS.clear();
        }
    }

    @Generated
    private Predications() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

