/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.advancedban.core.managers;

import com.balugaq.advancedban.api.enums.EventType;
import com.balugaq.advancedban.api.utils.Debug;
import com.balugaq.advancedban.api.utils.Lang;
import com.balugaq.advancedban.api.utils.Predications;
import com.balugaq.advancedban.implementation.AdvancedBan;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.List;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventPriority;

public final class PredicationsLoader {
    public static final String BANS_KEY = "bans";
    public static final String ENABLED_KEY = "enabled";
    public static final String PRIORITY_KEY = "priority";
    public static final String ITEMS_KEY = "items";
    public static final String PLAYERS_KEY = "players";
    public static final String PERMISSIONS_KEY = "permissions";
    public static final String EXAMPLE_ITEM = "a_slimefun_id";
    public static final String EXAMPLE_PLAYER = "a_player_name";
    public static final String EXAMPLE_PERMISSION_NODE = "a_permission_node";
    public static final String DEFAULT_PRIORITY = "NORMAL";

    public static void loadPredications() {
        boolean configured = true;
        boolean configuredDifferentItem = false;
        FileConfiguration configuration = AdvancedBan.getInstance().getConfigManager().getBans();
        Debug.debug("Loading predications");
        for (String key : configuration.getKeys(false)) {
            Debug.debug("Key: " + key);
        }
        Debug.debug("Loading bans");
        ConfigurationSection bans = configuration.getConfigurationSection(BANS_KEY);
        if (bans == null) {
            return;
        }
        for (EventType eventType : EventType.values()) {
            ConfigurationSection eventSection;
            String key = eventType.getKey();
            if (!bans.contains(key) || (eventSection = bans.getConfigurationSection(key)) == null) continue;
            for (String groupKey : eventSection.getKeys(false)) {
                EventPriority eventPriority;
                boolean enabled;
                ConfigurationSection groupSection = eventSection.getConfigurationSection(groupKey);
                if (groupSection == null || !(enabled = groupSection.getBoolean(ENABLED_KEY, true))) continue;
                String eventPriorityStr = groupSection.getString(PRIORITY_KEY, DEFAULT_PRIORITY).toUpperCase();
                try {
                    eventPriority = EventPriority.valueOf((String)eventPriorityStr.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    PredicationsLoader.invalidKey(key + "." + groupKey + ".priority", eventPriorityStr);
                    eventPriority = EventPriority.NORMAL;
                }
                List players = groupSection.getStringList(PLAYERS_KEY);
                List permissions = groupSection.getStringList(PERMISSIONS_KEY);
                List items = groupSection.getStringList(ITEMS_KEY);
                for (String rid : items) {
                    String id = rid.toUpperCase();
                    SlimefunItem slimefunItem = SlimefunItem.getById((String)id);
                    if (slimefunItem == null) {
                        if (id.equalsIgnoreCase(EXAMPLE_ITEM)) {
                            configured = false;
                            continue;
                        }
                        PredicationsLoader.invalidKey(key + "." + groupKey + ".items", id);
                        continue;
                    }
                    Predications.addPredication(id, eventType, eventPriority);
                    if (players != null && !players.isEmpty()) {
                        if (players.size() == 1 && ((String)players.get(0)).equalsIgnoreCase(EXAMPLE_PLAYER)) continue;
                        Predications.addBypassPlayers(id, eventType, players);
                    }
                    if (permissions != null && !permissions.isEmpty()) {
                        if (permissions.size() == 1 && ((String)permissions.get(0)).equalsIgnoreCase(EXAMPLE_PERMISSION_NODE)) continue;
                        Predications.addBypassPermissions(id, eventType, permissions);
                    }
                    AdvancedBan.getInstance().getLogger().info(Lang.getMessage("load.added-predication", "id", id, "event_priority", eventPriority, "event_type", eventType.name()));
                    configuredDifferentItem = true;
                }
            }
        }
        if (!configured && !configuredDifferentItem) {
            AdvancedBan.getInstance().getLogger().warning(Lang.getMessage("load.no-configured-predications"));
        }
    }

    public static void invalidKey(String path, String value) {
        AdvancedBan.getInstance().getLogger().severe(Lang.getMessage("load.invalid-bans-key"));
        AdvancedBan.getInstance().getLogger().severe(Lang.getMessage("load.path", "path", path));
        AdvancedBan.getInstance().getLogger().severe(Lang.getMessage("load.value", "value", value));
    }

    @Generated
    private PredicationsLoader() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

